<?php
/**
	PHP SDK for connect.qq.com (using OAuth2)
	* @author zhangbingbing
	* @copyright			(C) 2014 NiubiCMS
	* @lastmodify			2014-10-31
	*/
class TencentOAuthV2
{
	public $qz_akey;
	public $qz_skey;
	public $redirect_uri;
	public $access_token;
	public $openid;
	
	function __construct($akey,$skey,$rurl)
	{
		$this->qz_akey=$akey;
		$this->qz_skey=$skey;
		$this->redirect_uri=$rurl;
		
	}
	
	function getAuthorizeURL()
	{
		$_SESSION['state'] = md5(uniqid(rand(), TRUE));
		return "https://graph.qq.com/oauth2.0/authorize?response_type=code&client_id=" 
				. $this->qz_akey . "&redirect_uri=" . urlencode($this->redirect_uri) . "&state="
				. $_SESSION['state'];
	}

	function getAccess_token()
	{
		$token_url = "https://graph.qq.com/oauth2.0/token?grant_type=authorization_code&"
				. "client_id=" . $this->qz_akey . "&redirect_uri=" . urlencode($this->redirect_uri)
				. "&client_secret=" . $this->qz_skey . "&code=" . $_GET['code'];
		$response = get_url_contents($token_url);

		if (strpos($response, "callback") !== false)
		{
			$lpos = strpos($response, "(");
			$rpos = strrpos($response, ")");
			$response  = substr($response, $lpos + 1, $rpos - $lpos -1);
			$msg = jsondecode($response);
			if (isset($msg->error))
			{
				exit($msg->error);
			}
		}

		$params = array();
		parse_str($response, $params);
		$this->access_token=$params['access_token'];
		return $this->access_token;
	}

	function getOpenid()
	{
		$graph_url = "https://graph.qq.com/oauth2.0/me?access_token=".$this->access_token;
		$str  = get_url_contents($graph_url);
		if (strpos($str, "callback") !== false)
		{
			$lpos = strpos($str, "(");
			$rpos = strrpos($str, ")");
			$str  = substr($str, $lpos + 1, $rpos - $lpos -1);
		}

		$user = jsondecode($str);
		if (isset($user->error))
		{
			exit($user->error_description);
		}
		$this->openid=$user->openid;
		return $this->openid;
	}

	function get_user_info()
	{
		$get_user_info = "https://graph.qq.com/user/get_user_info?"
		. "access_token=" . $this->access_token
		. "&oauth_consumer_key=" . $this->qz_akey
		. "&openid=" . $this->openid
		. "&format=json";

		$info = get_url_contents($get_user_info);
		$arr = json_decode($info, true);

		return $arr;
	}
}
?>